*! version 5.0
* 13 August 2018
* NIDS
* Master Income do file updated for Nids Wave 4

* THIS IS 3nd INCOME DO FILE - PRE-IMPUTATION AGGREGATION DO FILE: 3 OF 7
* This file creates production-level and income variables for section h (agriculture) of the household questionaire

*=====================================================================================================================================
* GLOBALS FOR DATA FILES, DO FILES AND VERSION SUFFIXES

* DEFINED IN "Master Income do file (1 of 7)"

version 12.1

*=====================================================================================================================================

use "$DataIN\HHQuestionnaire_$VersionIN.dta", clear

cap rename hhid w4_hhid
merge 1:1 w4_hhid using "$DataIN\hhderived_$VersionIN.dta", keepusing(w4_dc2011)

*========================================================================================================================================================
*PREPARING THE DATA: SET NON-RESPONSE CODES TO SYSTEM MISSING

cap rename w4_h_* *
foreach var of varlist agcr	agcrml	agcrmlhkg	agcrmlsllyn	agcrmlskg	agcrmlval	agcrsor	agcrsorhkg	agcrsorsllyn	agcrsorskg	agcrsorval	agcrfrt	agcrfrthkg	agcrfrtsllyn	agcrfrtskg	agcrfrtval	agcrpot	agcrpothkg	agcrpotsllyn	agcrpotskg	agcrpotval	agcrpmp	agcrpmphkg	agcrpmpsllyn	agcrpmpskg	agcrpmpval	agcrmad	agcrmadhkg	agcrmadsllyn	agcrmadskg	agcrmadval	agcroni	agcronihkg	agcronisllyn	agcroniskg	agcronival	agcrdb	agcrdbhkg	agcrdbsllyn	agcrdbskg	agcrdbval	agcrgrnveg	agcrgrnveghkg	agcrgrnvegsllyn	agcrgrnvegskg	agcrgrnvegval	agls	aglscat	aglscatown	aglscatsll	aglscatval	aglscatcon	aglsshp	aglsshpown	aglsshpsll	aglsshpval	aglsshpcon	aglsgt	aglsgtown	aglsgtsll	aglsgtval	aglsgtcon	aglspig	aglspigown	aglspigsll	aglspigval	aglspigcon	aglshrs	aglshrsown	aglshrssll	aglshrsval	aglshrscon	aglsdnk	aglsdnkown	aglsdnksll	aglsdnkval	aglsdnkcon	aglschc	aglschcown	aglschcsll	aglschcval	aglschccon	ageggnum	ageggu	agcwmlkmth	agcwmlkamt	aggtmlkmth	aggtmlkamt	agilab	agilabspn	agifrt	agifrtspn	agiman	agimanspn	agichm	agichmspn	agiplgh	agiplghspn	agiseed	agiseedspn	agidip	agidipspn	agivet	agivetspn	agifeed	agifeedspn	agiinv	agiinvspn	agirep	agirepspn {
replace `var' = . if `var' <0
}

*========================================================================================================================================================
*PART 1 - INCOME FROM CROP PRODUCTION

*CREATING PRICE PER KG FOR EACH CROP

/*The farm gate price is used in cases where no crops were sold by the household. If crops were sold by the household, then the value per kg is calculated*/

**RERENCES TO PRICES

* W4: DAFF (Department of Agriculture, Fisheries and Forestry) 2014 amd 2015 prices were obtained from the Abstract of Agricultural Statistics, 2014, 2015 (latest version, obtained directly from DAFF).
* W3: DAFF (Department of Agriculture, Fisheries and Forestry) 2012 prices were obtained from http://www.daff.gov.za/docs/statsinfo/Abstact2013.pdf
* W3: FW Farmers Weekly June 2012 Edition

		**Creating a per kg value for mealies** 
		*W4 price = 2.122 per kg DAFF2014
		*W4 price = 2.026 per kg DAFF2014
		*W3 price = R2.144 per kg DAFF2013, R2.280 per kg FW 
		*W1 price = R2 (R1.606 DAFF 2008)
		gen  mealiekgprice = 2.122 if agcrml == 1 & agcrmlhkg> 0 &  agcrmlhkg!= . //? hh harvested mealies, ? hh sold
		replace  mealiekgprice= agcrmlval/ agcrmlskg if agcrmlval>0 & agcrmlval!= . & agcrmlskg> 0 & agcrmlskg!=.


		**Creating a per kg value for Sorghum** 
		*W4 price = 2.812 per kg DAFF2015
		*W4 price = 2.632 per kg DAFF2014
		*W3 price = R2.674 per kg DAFF2013, R3.045 per kg FW
		*W1 price = R2 (R1.744 DAFF 2008)
		gen  sorghumkgprice= 2.812 if agcrsor == 1 &  agcrsorhkg > 0 &  agcrsorhkg!=.  //? hh harvested sorghum, ? sold
		replace sorghumkgprice= agcrsorval/agcrsorskg if agcrsorval>0 & agcrsorval!=. & agcrsorskg> 0 & agcrsorskg!= .

		
		**Creating a per kg value for fruit** 
		*W4 price = R7.570 per kg DAFF2015(average price for apples (R5.817), apricots (R8.126), grapes (R10.771), pears (R5.567))
		*W4 price = R6.874 per kg DAFF2014(average price for apples (R5.7), apricots (R6.618), grapes (R9.825), pears (R5.351))
		*W3 price = R6.187 per kg DAFF2013(average price for apples (R5.258), apricots (R6.445), grapes (R8.207), pears (R4.841))    
		*W1 price = R3.5(citrus fruit 1.5(deciduous fruit)) 
		gen  fruitkgprice= 7.570 if agcrfrt == 1 &  agcrfrthkg > 0 &  agcrfrthkg!=. //? hh harvested fruit, ? hh sold
		replace fruitkgprice= agcrfrtval/agcrfrthkg if agcrfrtval>0 & agcrfrtval!=. & agcrfrthkg> 0 & agcrfrthkg!= .
		
		
		**Creating a per kg value for potato** 
		*W4 price = R3.576 Average of ((R3.428 per kg potatoe,  R3.724 per kg sweet potatoe (DAFF2015))
		*W4 price = R3.093 Average of ((R3.376 per kg potatoe,  R2.809 per kg sweet potatoe (DAFF2014))
		*W3 price = R3.148 Average of ((R2.646 per kg potatoe, R3.650 per kg sweet potatoe (DAFF2013)), R3.839 per kg FW
		*W1 price = R3 (R2.20  Average of ((R2.076 potatoe & R2.325 sweet potatoes) DAFF 2008)
		gen  potatokgprice = 3.576 if agcrpot == 1 & agcrpothkg> 0 & agcrpothkg!=. //? hh harvested potatoes, ? hh sold
		replace  potatokgprice= agcrpotval/ agcrpotskg if agcrpotval>0 & agcrpotval!=. & agcrpotskg>0 & agcrpotskg!=.

		
		**Creating a per kg value for pumpkin** 
		*W4 price = R2.6775 Average of (R2.128 per kg pumpkin & R3.227 butternut squash) DAFF2015
		*W4 price = R2.514 Average of (R2.155 per kg pumpkin & R2.873 butternut squash) DAFF2014
		*W3 price = R2.013 Average of (R1.617 per kg pumpkin & R2.409 butternut squash) DAFF2013, 
		*W1 price = R4  (R1.531  Average if (R1.250 pumpkin & R1.813 butternut squash) DAFF 2008 )
		gen  pumpkinkgprice = 2.678 if agcrpmp == 1 & agcrpmphkg > 0 & agcrpmphkg !=. //? hh harvested pumpkin, ? hh sold
		replace  pumpkinkgprice= agcrpmpval/ agcrpmpskg  if agcrpmpval >0 & agcrpmpval!=. & agcrpmpskg>0 & agcrpmpskg!=.


		**Creating a per kg value for madumbe** 
		*W4 price = R3.724. We used the price of sweet potatoes from DAFF2015 
		*W4 price = R2.809. We used the price of sweet potatoes from DAFF2014 (note that sweet potatoe prices have decreased since 2012, which may have not been the case for madumbe) 
		*W3 price = R3.650. We used the price of sweet potatoes from DAFF2013
		*W1 price = R3
		gen  madumbekgprice= 3.724 if agcrmad == 1 & agcrmadhkg > 0 & agcrmadhkg !=. //? hh harvested madumbe, ? hh sold
		replace madumbekgprice = agcrmadval/ agcrmadskg if agcrmadval >0 & agcrmadval!=. & agcrmadskg >0 & agcrmadskg !=.


		**Creating a per kg value for Onions**
		*W4 price = R3.334 per kg DAFF2015
		*W4 price = R3.433 per kg DAFF2014
		*W3 price = R2.586 per kg DAFF2013, R2.453 per kg Farmers Weekly 25 Oct 2013 
		*W1 price = R4 (R2.167 DAFF 2008)
		gen  onionskgprice =  3.334 if agcroni == 1 & agcronihkg >0 & agcronihkg != . //? hh harvested onions, ? hh sold
		replace onionskgprice = agcronival/ agcroniskg if agcronival >0 & agcronival!=. & agcroniskg >0 & agcroniskg !=.


		**Creating a per kg value for legumes** 
		*W4 price = R13.631 Average of (R20.00 Large white kidney beans, R10.525 small white beans, R11.5 sugar beans, R12.5 Haricot beans) DAFF2015
		*W4 price = R12.3268 Average of (R14.5 Large white kidney beans, R9.63 small white beans, R12.677 sugar beans, R12.5 Haricot beans) DAFF2014
		*W3 price = R11.1135 Average of (R14.00 Large white kidney beans, R8.318.00 Small white beans, R10.636 Sugar beans, R11.50 Haricot beans) DAFF2013, R2.453 per kg FW
		*W1 price = R2
		gen  legumeskgprice= 13.631 if agcrdb == 1 & agcrdbhkg >0 & agcrdbhkg !=. //? hh harvested legumes, ? hh sold
		replace legumeskgprice = agcrdbval/ agcrdbskg if agcrdbval >0 & agcrdbval !=. & agcrdbskg >0 & agcrdbskg !=.


		**Creating a per kg value for green veg**  
		*W4 price = R2.180 per kg (cabbage) DAFF2015 
		*W4 price = R2.074 per kg (cabbage) DAFF2014 
		*W3 price = R1.753 per kg (cabbage) DAFF2013, R2.032 per kg FW
		*W1 price = R2) (R1.080 DAFF 2008)
		gen  greenvegkgprice= 2.180 if agcrgrnveg == 1 & agcrgrnveghkg >0 & agcrgrnveghkg !=. //? hh harvested green veg, ? hh sold
		replace greenvegkgprice = agcrgrnvegval/ agcrgrnvegskg if agcrgrnvegval >0 & agcrgrnvegval !=. & agcrgrnvegskg >= 0 & agcrgrnvegskg !=.

		
		**Creating a per kg value for tomatoes or peppers**  
		*W4 price = R6.082 per kg (tomatoes) DAFF2015
		*W4 price = R4.501 per kg (tomatoes) DAFF2014
		*W1 price 
		gen  tomatokgprice= 6.082 if agcrgrntom == 1 & agcrgrntomhkg >0 & agcrgrntomhkg !=.   //? hh harvested tomatoes and peppers, ? hh sold
		replace tomatokgprice = agcrgrntomval/ agcrgrntomskg if agcrgrntomval >0 & agcrgrntomval !=. & agcrgrntomskg >= 0 & agcrgrntomskg !=.
		
		**Creating a per kg value for herbs**  
		*R2 (FOR PRETEST ONLY!!!)
		*W1 price  
		gen  herbkgprice= 2.5 if agcrherb == 1 & agcrherbhkg >0 & agcrherbhkg !=. //? hh harvested herbs, ? hh sold
		replace herbkgprice = agcrherbval/ agcrherbskg if agcrherbval >0 & agcrherbval !=. & agcrherbskg >= 0 & agcrherbskg !=.
*-------------------------------------------------------------------------------------------------------------------

**CREATING AGRICULTURE INCOME AS PRICE PER KG * NUMBER OF KG HARVESTED

	*mealies Income
	gen mealieinc = agcrmlhkg*mealiekgprice
	replace mealieinc = agcrmlval if agcrmlhkg == . & agcrmlval >0 & agcrmlval!=.  
	//1 hh that does not know how much they harvested, but know how much money they received from selling mealies

	*Sorghum Income	
	gen sorghuminc = agcrsorhkg*sorghumkgprice

	*Fruit Income	
	gen fruitinc = agcrfrthkg*fruitkgprice
	
	*Potato Income
	gen potatoinc = agcrpothkg*potatokgprice
	replace potatoinc =  agcrpotval if agcrpothkg == . & agcrpotval >0 & agcrpotval !=. 
	//2 hh that do not know how much they harvested, but know how much money they received from selling potatoes

	*Pumpkin Income
	gen pumpkininc = agcrpmphkg*pumpkinkgprice
	
	*Madumbe Income 
	gen madumbeinc = agcrmadhkg*madumbekgprice
	replace  madumbeinc = agcrmadval if agcrmadhkg == . &  agcrmadval>0 & agcrmadval !=.
	//2 hh that do not know how much they harvested, but know how much money they received from selling madumbe
	
	*Onion Income
	gen onioninc = agcronihkg*onionskgprice
	replace onioninc = agcronival if agcronihkg == . & agcronival >0 & agcronival !=.
	//2 hh that do not know how much they harvested, but know how much money they received from selling onions

	*Legume Income
	gen legumeinc = agcrdbhkg*legumeskgprice
	
	*Green Veg income
	gen greenveginc = agcrgrnveghkg*greenvegkgprice
	
	*Tomatoes or peppers
	gen tomatoinc = agcrgrntomhkg*tomatokgprice
	
	*Herbs
	gen herbinc = agcrherbhkg*herbkgprice


drop *price

*-------------------------------------------------------------------------------------------------------------------

*CALCULATING TOTAL INCOME FROM CROP PRODUCTION
egen produceinc = rowtotal(mealieinc sorghuminc fruitinc potatoinc pumpkininc madumbeinc onioninc legumeinc greenveginc tomatoinc herbinc), mi
 
 
 
 
 
 
*========================================================================================================================================================




*PART 2 - INCOME FROM LIVESTOCK  PRODUCE 



*ESTIMATING VALUE OF A SINGLE UNIT OF LIVESTOCK 

	**Creating price per cow value 
	*Use median of sample as price per cow for hh that did not sell any livestock
	*W1 price = R2 800)
	gen cowprice = .
	replace cowprice=aglscatval/aglscatsll
	egen cowprice_median = median(cowprice)  //Median price is R5000
	sum cowprice, d
	replace cowprice= cowprice_median if cowprice==. & (aglscatsll>0 & aglscatsll!=.) 
	replace cowprice= cowprice_median if cowprice==. & (aglscatcon>0 & aglscatcon!=.)
	drop cowprice_median
	
	**Creating price per sheep value 
	*Use median of sample as price per cow for hh that did not sell any livestock
	*W1 price = R600)
	gen sheepprice=.
	replace sheepprice=aglsshpval/aglsshpsll
	egen sheepprice_median = median(sheepprice) //Median price is R1000
	sum sheepprice, d	
	replace sheepprice=sheepprice_median if sheepprice==. & aglsshpsll>0 & aglsshpsll!=.
	replace sheepprice=sheepprice_median if sheepprice==. & aglsshpcon>0 & aglsshpcon!=.
	drop sheepprice_median
	
	**Creating price per goat value 
	*Use median of sample as price per cow for hh that did not sell any livestock 
	*W1 price = R500)
	gen goatprice=.
	replace goatprice=aglsgtval/aglsgtsll
	egen goatprice_median = median(goatprice) //Median price is R800
	sum goatprice, d	
	replace goatprice=goatprice_median if goatprice==. & aglsgtsll>0 & aglsgtsll!=.
	replace goatprice=goatprice_median if goatprice==. & aglsgtcon>0 & aglsgtcon!=.
	replace goatprice = goatprice_median if aglsgtsll>0 & aglsgtsll!=. & aglsgtval == 0 //1 hh, sold 2 goats and got R0
	drop goatprice_median
	
	**Creating price per pig value 
	*R600 per pig 
	*W1 price = R)
	gen pigprice=.
	replace pigprice=aglspigval/aglspigsll
	egen pigprice_median = median(pigprice) //Median price is R120
	sum pigprice, d
	replace pigprice=600 if pigprice==. & aglspigsll>0 & aglspigsll!=.  // Median price of R120 is too low so the maz price from the sample of 600 is assigned
	replace pigprice=600 if pigprice==. & aglspigcon>0 & aglspigcon!=.  // Median price of R120 is too low so the maz price from the sample of 600 is assigned
	drop pigprice_median
	
	**Creating price per horse value 
	*R1 200 per horse
	*W1 price = R1 000)
	gen horseprice=.
	replace horseprice=aglshrsval/aglshrssll
	egen horseprice_median = median(horseprice) //Median price is R5000
	sum horseprice, d
	replace horseprice=horseprice_median if horseprice==. & aglshrssll>0 & aglshrssll!=.
	replace horseprice=horseprice_median if horseprice==. & aglshrscon>0 & aglshrscon!=.
	drop horseprice_median
	
	**Creating price per donkey value 
	*R1 000 per donkey 
	*W1 price = R)
	gen donkeyprice=.
	replace donkeyprice=aglsdnkval/aglsdnksll
	egen donkeyprice_median = median(donkeyprice) //No household sold any donkeys do mo price was calculated from the sample
	sum donkeyprice, d
	replace donkeyprice=donkeyprice_median if donkeyprice==. & aglsdnksll>0 & aglsdnksll!=.
	replace donkeyprice=donkeyprice_median if donkeyprice==. & aglsdnkcon>0 & aglsdnkcon!=.
	drop  donkeyprice_median
	
	**Creating price per chicken value 
	*R40 per chicken
	*W1 price = R30)
	gen chickenprice=.
	replace chickenprice=aglschcval/aglschcsll
	egen chickenprice_median = median(chickenprice) //Median price is R45
	sum chickenprice, d
	replace chickenprice=chickenprice_median if chickenprice==. & aglschcsll>0 & aglschcsll!=.
	replace chickenprice=chickenprice_median if chickenprice==. & aglschccon>0 & aglschccon!=.
	replace chickenprice = chickenprice_median if aglschcsll>0 & aglschcsll!=. & aglschcval == 0 //1 hh, sold 2 goats and got R0
	drop chickenprice_median
	
*---------------------------------------------------------------------------------------------------

*LIVESTOCK INCOME
	egen num_cattle= rowtotal(aglscatsll aglscatcon), mi
	gen cattleinc = num_cattle*cowprice

	egen num_sheep = rowtotal(aglsshpsll aglsshpcon), mi
	gen sheepinc = num_sheep*sheepprice

	egen num_goat = rowtotal(aglsgtsll aglsgtcon), mi
	gen goatinc = num_goat*goatprice

	egen num_pig =  rowtotal(aglspigsll aglspigcon), mi
	gen piginc	= num_pig*pigprice

	egen num_horse = rowtotal(aglshrssll aglshrscon), mi
	gen horseinc = num_horse*horseprice

	egen num_donkey = rowtotal(aglsdnksll aglsdnkcon), mi
	gen donkeyinc = num_donkey*donkeyprice

	egen num_chicken = rowtotal(aglschcsll aglschccon), mi
	gen  chickeninc= num_chicken*chickenprice

*TOTAL INCOME FROM LIVESTOCK PRODUCE
	egen animalinc =  rowtotal(cattleinc goatinc sheepinc piginc horseinc donkeyinc chickeninc), mi

drop cattleinc sheepinc goatinc piginc horseinc donkeyinc chickeninc num_*



*========================================================================================================================================================




*PART 3 - INCOME FROM LIVESTOCK-RELATED PRODUCE


*INCOME FROM EGGS
	replace ageggu = 1 if ageggu ==. & ageggnum>0 & ageggnum!=. // ****NB: 12 hh with # egg >0 but no units (i.e. ageggu ==-9)
	gen eggunits=.
	replace eggunits = ageggnum*12 if ageggu==1


	replace eggunits = ageggnum if ageggu==2
	replace eggunits=-3 if eggunits==-108
	replace eggunits=-3 if eggunits==-36
	gen eggunitannual=.
	replace eggunitannual=eggunits*12
	replace eggunitannual=-3 if eggunitannual==-36
	replace eggunitannual=-3 if eggunitannual==-108
	
	*W4 price = R0.8934 per egg DAFF2015   //1072.1/(12*1000)
	*W4 price = R0.8288 per egg DAFF2014
	*W3 price = R0.7701 per egg DAFF2013 
	*W1 price = R0.50 (R0.6249 DAFF 2008)
	gen egginc=.
	replace egginc=eggunitannual* 0.8288

	

*INCOME FROM MILK OR SOUR MILK FROM COW
	
	gen cowmilklitre=.
	replace cowmilklitre = agcwmlkmth * agcwmlkamt
	replace cowmilklitre = 0 if agcwmlkamt < 0
	replace cowmilklitre = agcwmlkamt if agcwmlkamt> 0 & agcwmlkamt!= . & agcwmlkmth <0
	
	*W4 price = R3.820 per litre DAFF2015	//382.0/100
	*W4 price = R3.485 per litre DAFF2014
	*W3 price = R2.992 per litre DAFF2013
	*W1 price = R1.50 (R2.733 DAFF 2008)
	gen cowmilkinc=.
	replace cowmilkinc=cowmilklitre* 3.820
	
*INCOME FROM MILK OR SOUR MILK FROM SHEEP
	
	gen shpmilklitre=.
	replace shpmilklitre = agshpmlkmth * agshpmlkamt
	replace shpmilklitre = 0 if agshpmlkamt < 0
	replace shpmilklitre = agshpmlkamt if agshpmlkamt> 0 & agshpmlkamt!= . & agshpmlkamt <0
	
	
	//Assume that price for sheep milk is the same as price for cow milk since there was no other reference	
	gen shpmilkinc=.
	replace shpmilkinc=shpmilklitre* 3.820


*INCOME FROM MILK OR SOUR MILK FROM GOAT

	gen goatmilklitre=.
	replace goatmilklitre = aggtmlkmth * aggtmlkamt
	replace goatmilklitre = 0 if aggtmlkamt < 0
	replace goatmilklitre = aggtmlkamt if aggtmlkamt> 0 & aggtmlkamt!= . & aggtmlkmth <0
	

	//Assume that price for goat milk is the same as price for cow milk since there was no other reference
	gen goatmilkinc=.
	replace goatmilkinc=goatmilklitre* 3.820   


*TOTAL INCOME FROM LIVESTOCK-RELATED PRODUCE
egen animalbyprodinc =  rowtotal(egginc cowmilkinc goatmilkinc shpmilkinc), mi

drop eggunits eggunitannual cowmilklitre goatmilklitre
*========================================================================================================================================================

*PART 4 - CALCULATING COST OF INPUTS

*THINGS YOU HAD TO DO TO PRODUCE CROPS

	gen buylabour=.
	replace buylabour=agilabspn
	replace buylabour=0 if buylabour==.
	replace buylabour=0 if buylabour<0

	gen buyfertil=.
	replace buyfertil=agifrtspn
	replace buyfertil=0 if buyfertil==.
	replace buyfertil=0 if buyfertil<0

	gen buymanure=.
	replace buymanure=agimanspn
	replace buymanure=0 if buymanure==.
	replace buymanure=0 if buymanure<0

	gen buychem=.
	replace buychem=agichmspn
	replace buychem=0 if buychem==.
	replace buychem=0 if buychem<0

	gen buyplough=.
	replace buyplough=agiplghspn
	replace buyplough=0 if buyplough==.
	replace buyplough=0 if buyplough<0

	gen buyseeds=.
	replace buyseeds=agiseedspn
	replace buyseeds=0 if buyseeds==.
	replace buyseeds=0 if buyseeds<0

	gen buydip=.
	replace buydip=agidipspn
	replace buydip=0 if buydip==.
	replace buydip=0 if buydip<0

	gen buyvet=.
	replace buyvet=agivetspn
	replace buyvet=0 if buyvet==.
	replace buyvet=0 if buyvet<0

	gen buyfeed=.
	replace buyfeed=agifeedspn
	replace buyfeed=0 if buyfeed==.
	replace buyfeed=0 if buyfeed<0

	gen buyinvest=.
	replace buyinvest=agiinvspn
	replace buyinvest=0 if buyinvest==.
	replace buyinvest=0 if buyinvest<0

	gen buyrepair=.
	replace buyrepair=agirepspn
	replace buyrepair=0 if buyrepair==.
	replace buyrepair=0 if buyrepair<0
	
	gen buywater=.
	replace buywater=agiwatspn
	replace buywater=0 if buywater==.
	replace buywater=0 if buywater<0

egen inputcosts= rowtotal(buylabour buyfertil buymanure buychem buyplough buyseeds buydip buyvet buyfeed buyinvest buyrepair buywater), mi


*=====================================================================================================================================================

*PART 5 - Aggregation of all income variables
egen agric_inc = rowtotal (producein  animalinc  animalbyprodinc), mi
gen netagriincome= agric_inc  - inputcosts
replace netagriincome=. if ag==2

keep w4_hhid netagriincome 
rename netagriincome hhagric
replace hhagric=0 if hhagric<0
replace hhagric=hhagric/12
label variable hhagric "Household average monthly income from subsistence agriculture"


sort w4_hhid

save "$DataOUT\hhagric.dta", replace

*=====================================================================================================================================
